//
//  InspectorViewKerningController.h
//  GlyphsCore
//
//  Created by Georg Seifert on 12.02.12.
//  Copyright (c) 2012 schriftgestaltung.de. All rights reserved.
//

#import "GSInspectorViewController.h"
#import <Cocoa/Cocoa.h>

@class GSLayer;

@interface InspectorViewKerningController : GSInspectorViewController {
	GSLayer *__unsafe_unretained _previousLayer;
	GSLayer *__unsafe_unretained _nextLayer;
	IBOutlet NSButton *leftExceptionButton;
	IBOutlet NSButton *rightExceptionButton;

	IBOutlet NSTextField *leftKerningField;
	IBOutlet NSTextField *leftGroupField;
	IBOutlet NSTextField *rightGroupField;
	IBOutlet NSTextField *rightKerningField;

	NSImage *exception;
	NSImage *noException;
	NSImage *rightTransferValue;
	NSImage *leftTransferValue;
}

@property (unsafe_unretained, nonatomic) GSLayer *previousLayer;
@property (unsafe_unretained, nonatomic) GSLayer *nextLayer;

- (void)setAlternateButtons:(NSNotification *)theNotification;

- (IBAction)setLeftKerning:(id)sender;

- (IBAction)setLeftGroup:(id)sender;

- (IBAction)setLeftException:(id)sender;

- (IBAction)setRightKerning:(id)sender;

- (IBAction)setRightGroup:(id)sender;

- (IBAction)setRightException:(id)sender;
@end
